$(function () {
    calc();

    $('#calc_plan').on('change', calc);
    $('#inv_amount')
        .on('keyup change', calc)
        .on('keypress', isNumberKey);
});

function isNumberKey(evt) {
    var charCode = evt.which ? evt.which : evt.keyCode;
    return !(charCode > 31 && (charCode < 45 || charCode > 57));
}

function calc() {
    var plan = $('#calc_plan').val();
    var amount = Number($('#inv_amount').val()) || 0;
    var percent = 0;

    const plans = {
        1: [
            { min: 2500, max: 7500, roi: 50 }
        ],
        2: [
            { min: 7500, max: 9999, roi: 75 }
        ],
        3: [
            { min: 10000, max: Infinity, roi: 120 }
        ],
        4: [
            { min: 50000, max: Infinity, roi: 200 }
        ],
        5: [
            { min: 50, max: 10000, roi: 2000 }
        ],
        6: [
            { min: 10, max: 500, roi: 50 },
            { min: 7500, max: 9999, roi: 75 },
            { min: 10000, max: 99999, roi: 120 },
            { min: 50000, max: Infinity, roi: 200 },
            { min: 4001, max: 8000, roi: 1200 },
            { min: 8001, max: 30000, roi: 1800 }
        ]
    };

    if (plans[plan]) {
        for (var i = 0; i < plans[plan].length; i++) {
            var tier = plans[plan][i];
            if (amount >= tier.min && amount <= tier.max) {
                percent = tier.roi;
                break;
            }
        }
    }

    $('#assign_per').text(percent + '%');

    var total = amount * percent / 100;
    $('#total_return').text('$' + total.toFixed(2));

    if (percent === 0) {
        $('#net_profit').text('$0.00');
    } else {
        $('#net_profit').text('$' + (total - amount).toFixed(2));
    }
}
